/*
    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>



#define VER                 "0.1.1"
#define ALLEGRO_SERVER_DATA "Sea-Doo!GTXLimit"
#define ALLEGRO_LOGIN_DATA  "MinocquaWoodruff"
#define KEYPATH1            "Software\\Rhino Software\\AllegroSurf\\Login"
#define KEYPATH2            "Software\\Rhino Software\\AllegroSurf Voyager\\Servers"
#define BUFFSZ              4096



void doquery(HKEY key, u_char *buff, u_char *value);
void allegro_server_dec(u_char *password, int type);



int main(void) {
    HKEY    key;
    u_char  buff[BUFFSZ];
    int     i,
            numservers;


    setbuf(stdout, NULL);

    fputs("\n"
        "AllegroSurf login and servers passwords decoder "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    fputs("\n"
        "AllegroSurf login\n"
        "=================\n", stdout);
    if(RegOpenKeyEx(HKEY_CURRENT_USER, KEYPATH1, 0, KEY_READ, &key)) {
        fputs("\nError: registry key has not been found\n", stdout);
        fputs("\n    Press RETURN to exit\n", stdout);
        fgetc(stdin);
        exit(1);
    }
    doquery(key, buff, "UserID");
    printf("UserID:        %s\n", buff);
    doquery(key, buff, "Password");
    allegro_server_dec(buff, 0);
    printf("Password:      %s\n", buff);
    RegCloseKey(key);

    fputs("\n"
        "AllegroSurf Voyager servers passwords\n"
        "=====================================\n", stdout);
    if(RegOpenKeyEx(HKEY_CURRENT_USER, KEYPATH2, 0, KEY_READ, &key)) {
        fputs("\nError: registry key has not been found\n", stdout);
        fputs("\n    Press RETURN to exit\n", stdout);
        fgetc(stdin);
        exit(1);
    }
    doquery(key, buff, "Number of Servers");
    numservers = *buff;
    for(i = 0; i < numservers; i++) {
        fputc('\n', stdout);

        sprintf(buff, "Server %04d", i);
        doquery(key, buff, buff);
        printf("Server host:   %s:", buff);

        sprintf(buff, "ServerPort %04d", i);
        doquery(key, buff, buff);
        printf("%d\n", *(int *)buff);

        sprintf(buff, "ServerUserID %04d", i);
        doquery(key, buff, buff);
        printf("Username:      %s\n", buff);

        sprintf(buff, "ServerPassword %04d", i);
        doquery(key, buff, buff);
        allegro_server_dec(buff, 1);
        printf("Password:      %s\n", buff);
    }
    RegCloseKey(key);

    fputs("\n    Press RETURN to exit\n", stdout);
    fgetc(stdin);
    return(0);
}



void doquery(HKEY key, u_char *buff, u_char *value) {
    int     len = BUFFSZ;

    if(RegQueryValueEx(
      key,
      value,
      NULL,
      NULL,
      buff,
      (void *)&len)) {
        fputs("\nError: impossible to read the registry key\n", stdout);
        fputs("\n    Press RETURN to exit\n", stdout);
        fgetc(stdin);
        exit(1);
    }
}



void allegro_server_dec(u_char *password, int type) {
    u_int  tmp0,
            tmp1,
            tmp2,
            tmp3,
            eax,
            pwd1,
            pwd0,
            azz,
            *pwd,
            *encdata;
    int     len,
            lentmp,
            num;
    u_char  *ptr,
            *out;

    len = strlen(password);
    ptr = out = password;
    lentmp = len >> 1;
    while(lentmp--) {
        sscanf(ptr, "%02x", &num);
        *out++ = num;
        ptr += 2;
    }

    out = password;
    pwd = (u_int *)password;
    if(type) {
        encdata = (u_int *)ALLEGRO_SERVER_DATA;
    } else {
        encdata = (u_int *)ALLEGRO_LOGIN_DATA;
    }
    len >>= 4;
    while(len--) {
        azz = 0xc6ef3720;
        pwd0 = pwd[0];
        pwd1 = pwd[1];
        tmp0 = encdata[0];
        tmp1 = encdata[1];
        tmp2 = encdata[2];
        tmp3 = encdata[3];
        num = 32;
        while(num--) {
            eax = ((pwd0 >> 5) + tmp3) ^ ((pwd0 << 4) + tmp2);
            pwd1 -= (eax ^ (azz + pwd0));
            eax = ((pwd1 >> 5) + tmp1) ^ ((pwd1 << 4) + tmp0);
            pwd0 -= (eax ^ (azz + pwd1));
            azz += 0x61c88647;
        }
        *out++ = pwd0;
        pwd += 2;
    }
    *out = 0;
}


