/*
    Copyright 2009 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <openssl/evp.h>    // libcrypto.a -lgdi32 -lnetapi32

#ifdef WIN32
    #include <windows.h>
#else
    #define stricmp strcasecmp
#endif

typedef unsigned char   u8;
typedef unsigned int    u32;



#define VER         "0.1"



int regkeyr(HKEY hKey, LPCTSTR lpSubKey, LPTSTR lpValueName, char *buff, DWORD len);
u8 *pokerstars_key(void);
u8 *pokerstars_pwd(u8 *local_key, u8 *pwdstr);
void std_err(void);
void wait_exit(int ret);



int main(int argc, char *argv[]) {
    FILE    *fd;
    u8      buff[1024],
            *key    = NULL,
            *user   = NULL,
            *pwd    = NULL,
            *fname,
            *p;

    fputs("\n"
        "PokerStars password decrypter "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <user.ini/password> [key]\n"
            "\n", argv[0]);
        wait_exit(1);
    }
    fname = argv[1];

    if(argc < 3) {
        printf("- try to calculate the local key\n");
        key = pokerstars_key();
    } else {
        key = argv[2];
    }
    printf("- local key: %s\n", key);

    fd = fopen(fname, "rb");
    if(!fd) {
        pwd = strdup(fname);  // not needed
        pwd = pokerstars_pwd(key, pwd);
        if(pwd) {
            printf("\n  PASSWORD: %s\n", pwd);
        } else {
            printf("  password can't be decrypted\n");
        }
    } else {
        while(fgets(buff, sizeof(buff), fd)) {
            for(p = buff; *p && (*p != '\r') && (*p != '\n'); p++);
            *p = 0;

            p = strchr(buff, '=');
            if(!p) continue;
            *p++ = 0;
            if(!stricmp(buff, "Name")) {
                if(user) free(user);
                printf("\n  USERNAME: %s\n", p);
                user = strdup(p);
            } else if(!stricmp(buff, "PWD")) {
                pwd = pokerstars_pwd(key, p);
                if(pwd) {
                    printf("* PASSWORD: %s\n", pwd);
                    if(user && (strlen(pwd) >= strlen(user)) && !stricmp(pwd + strlen(pwd) - strlen(user), user)) {
                        pwd[strlen(pwd) - strlen(user)] = 0;
                        printf("  PASSWORD: %s\n", pwd);
                    }
                } else {
                    printf("  password can't be decrypted\n");
                }
            }
        }
        fclose(fd);
        printf("\n"
            "* this is the exact decrypted password as is without removing the username\n"
            "  usually concatenated after the real password (like passwordusername)\n");
    }

    wait_exit(0);
    return(0);
}



int regkeyr(HKEY hKey, LPCTSTR lpSubKey, LPTSTR lpValueName, char *buff, DWORD len) {
    HKEY    key;

    buff[0] = 0;
    if(RegOpenKeyEx(hKey, lpSubKey, 0, KEY_READ, &key) != ERROR_SUCCESS) {
        return(-1);
    }
    if(RegQueryValueEx(key, lpValueName, NULL, REG_NONE, buff, &len) != ERROR_SUCCESS) {
        RegCloseKey(key);
        return(-1);
    }
    RegCloseKey(key);
    buff[len] = 0;
    return(len);
}



// tested only on one computer so I have not verified if there are also other values to get
u8 *pokerstars_key(void) {
    static  u8  key[1024]   = "";   // fixed for the moment
    NCB     ncb;
    DWORD   InstanceA   = 0,
            InstanceB   = 0,
            volid       = 0;
    int     i;
    u8      install[32] = "",
            mac[32]     = "",
            sysvol[32]  = "",
            tmp[0x104],
            ncb_iface[0x100],
            ncb_stat[0x258];

    key[0] = 0;

    if(regkeyr(HKEY_CURRENT_USER, "Software\\VB and VBA Program Settings\\Plugin", "InstanceA", tmp, sizeof(InstanceA)) >= 0) {
        InstanceA = *(DWORD *)tmp;  // otherwise truncates some bytes
        regkeyr(HKEY_CURRENT_USER, "Software\\VB and VBA Program Settings\\Plugin", "InstanceB", tmp, sizeof(InstanceB));
        InstanceB = *(DWORD *)tmp;  // otherwise truncates some bytes
        sprintf(install, "%08X%08X", (u32)InstanceA, (u32)InstanceB);
        sprintf(key + strlen(key), "INSTALL=%s;", install);
    }

    memset(&ncb, 0, sizeof(ncb));
    ncb.ncb_command = NCBENUM;
    ncb.ncb_buffer  = ncb_iface;
    ncb.ncb_length  = sizeof(ncb_iface);
    if(!Netbios(&ncb)) {
        for(i = 0; i < ncb_iface[0]; i++) {
            memset(&ncb, 0, sizeof(ncb));
            ncb.ncb_command     = NCBRESET;
            ncb.ncb_lana_num    = ncb_iface[1 + i];
            if(Netbios(&ncb)) continue;

            memset(&ncb, 0, sizeof(ncb));
            memset(ncb.ncb_callname, ' ', sizeof(ncb.ncb_callname));
            ncb.ncb_command     = NCBASTAT;
            ncb.ncb_lana_num    = ncb_iface[1 + i];
            ncb.ncb_callname[0] = '*';
            ncb.ncb_buffer      = ncb_stat;
            ncb.ncb_length      = sizeof(ncb_stat);
            if(Netbios(&ncb)) continue;

            sprintf(mac, "%02X%02X%02X%02X%02X%02X", ncb_stat[0], ncb_stat[1], ncb_stat[2], ncb_stat[3], ncb_stat[4], ncb_stat[5]);
            sprintf(key + strlen(key), "MAC=%s;", mac);
        }
    }

    GetSystemDirectory(tmp, sizeof(tmp));
    tmp[3] = 0;
    GetVolumeInformation(tmp, NULL, 0, &volid, NULL, NULL, NULL, 0);
    sprintf(sysvol, "%08X", (u32)volid);
    sprintf(key + strlen(key), "SYSVOL=%s;", sysvol);
    return(key);
}



u8 *pokerstars_pwd(u8 *local_key, u8 *pwdstr) {
    EVP_CIPHER_CTX  ctx;
    int     a,
            b,
            len,
            pwdlen;
    u8      key[64],
            iv[64],
            *pwd,
            *keystr;

    if(local_key) {
        keystr = local_key;
    } else {
        keystr = pokerstars_key();
    }

    pwd = pwdstr;
    for(pwdlen = 0;; pwdlen++) {
        b = *pwdstr++;
        a = *pwdstr++;
        if(!a || !b) break;
        pwd[pwdlen] = ((b - 0x23) << 4) + a;
    }

    if(EVP_BytesToKey(
        EVP_des_cbc(),
        EVP_md5(),
        NULL,
        keystr,
        strlen(keystr),
        1,
        key,
        iv) <= 0) return(NULL);

    EVP_CIPHER_CTX_init(&ctx);

    if(EVP_CipherInit(
        &ctx,
        EVP_des_cbc(),
        key,
        iv,
        0) <= 0) return(NULL);

    if(EVP_EncryptUpdate(
        &ctx,
        pwd, &pwdlen,
        pwd, pwdlen) <= 0) return(NULL);

    if(EVP_EncryptFinal_ex(
        &ctx,
        pwd + pwdlen, &len) <= 0) return(NULL);
    pwdlen += len;

    EVP_CIPHER_CTX_cleanup(&ctx);

    pwd[pwdlen] = 0;
    return(pwd);
}



void std_err(void) {
    perror("\nError");
    wait_exit(1);
}



void wait_exit(int ret) {
    fprintf(stderr, "\npress RETURN to exit\n");
    fgetc(stdin);
    exit(ret);
}


