/*
    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>



#define VER     "0.2"
#define u_char  unsigned char



int read_show(FILE *fd, u_char *show, int bufflen, int enc);
void vivian_dec(u_char *pwd, int len);
void std_err(void);



int main(int argc, char *argv[]) {
    FILE    *fd;
    u_char  *fname;


    setbuf(stdout, NULL);

    fputs("\n"
        "Vivian mail password decoder "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <Accounts.vdb>\n"
            "\n", argv[0]);
        exit(1);
    }

    fname = argv[1];
    printf("- file %s\n", fname);
    fd = fopen(fname, "rb");
    if(!fd) std_err();

    if(fseek(fd, 857, SEEK_SET) < 0) std_err();

    for(;;) {
        if(read_show(fd, "Account Name",   50,  0) < 0) break;
        if(fseek(fd, 51, SEEK_CUR) < 0) break;
        if(read_show(fd, "POP3 server",    50,  0) < 0) break;
        if(read_show(fd, "POP3 user",      50,  0) < 0) break;
        if(read_show(fd, "POP3 pass",      62,  1) < 0) break;
        if(read_show(fd, "SMTP server",    50,  0) < 0) break;
        if(read_show(fd, "User",           50,  0) < 0) break;
        if(read_show(fd, "E-Mail",         80,  0) < 0) break;
        if(fseek(fd, 115, SEEK_CUR) < 0) break;
        if(read_show(fd, "SMTP user",      80,  0) < 0) break;
        if(read_show(fd, "SMTP pass",      80,  1) < 0) break;
        if(read_show(fd, "Reply-To",       100, 0) < 0) break;
        if(fseek(fd, 20, SEEK_CUR) < 0) break;
        printf("\n");
    }

    fclose(fd);
    return(0);
}



int read_show(FILE *fd, u_char *show, int bufflen, int enc) {
    int     showlen;
    u_char  buff[256];

    showlen = fgetc(fd);
    if(showlen < 0) return(-1);
    if(fread(buff, bufflen, 1, fd) != 1) return(-1);
    if(enc) vivian_dec(buff, showlen);
    printf("  %-12s   %.*s\n", show, showlen, buff);
    return(0);
}



void vivian_dec(u_char *pwd, int len) {
    short   esi,
            old;

    esi = 0xa2a;
    while(len--) {
        old = *pwd;
        *pwd++ = old ^ (esi >> 8);
        esi = ((esi + old) * 0xce6d) + 0x58bf;
    }
}



void std_err(void) {
    perror("\nError");
    exit(1);
}
